//---------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "usb_R7_3.h"
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------
TUSBDevice::TUSBDevice(UINT memberIndex)
{
   fMemberIndex = memberIndex;
   deviceList = (PDEVICE_DATA)new \
              DEVICE_DATA[((fMemberIndex+1)*sizeof(DEVICE_DATA))];
}
//---------------------------------------------------------
TUSBDevice::~TUSBDevice()
{
   releaseMemory(deviceList);
   ShowMessage("Pami zwolniona prawidowo.");
}
//---------------------------------------------------------
void TUSBDevice::displayError(const char* msg)
{
   ShowMessage(msg);
   exit(0);
};
//---------------------------------------------------------
BOOL TUSBDevice::getHidDeviceCapabilities(UINT memberIndex)
{
   HMODULE hHidLib;
   bool status;

   long (__stdcall* HidP_GetCaps)(IN PHIDP_PREPARSED_DATA PreparsedData,
                                 OUT PHIDP_CAPS Capabilities);
   bool (__stdcall* HidD_GetPreparsedData)(IN HANDLE  HidDeviceObject,
                                    OUT PHIDP_PREPARSED_DATA *PreparsedData);

   bool (__stdcall* HidD_FreePreparsedData)
                                    (IN PHIDP_PREPARSED_DATA PreparsedData);

   hHidLib = LoadLibrary("HID.DLL");
   if (!hHidLib)
    displayError("Bad doaczenia biblioteki HID.DLL.");

   (FARPROC&) HidP_GetCaps=GetProcAddress(hHidLib,
                                             "HidP_GetCaps");
   (FARPROC&) HidD_GetPreparsedData=GetProcAddress(hHidLib,
                                             "HidD_GetPreparsedData");
   (FARPROC&) HidD_FreePreparsedData=GetProcAddress(hHidLib,
                                             "HidD_FreePreparsedData");

   if (!HidP_GetCaps || !HidD_GetPreparsedData || !HidD_FreePreparsedData){
      FreeLibrary(hHidLib);
      displayError("Nie znaleziono jednej lub wicej funkcji eksportowych.");
   }
   status=HidD_GetPreparsedData(deviceList[memberIndex].hidDeviceObject,
                                &deviceList->preparsedData);
   if(status){
      HidP_GetCaps(deviceList->preparsedData, &deviceList->capabilities);
      deviceList[memberIndex].inputReportByteLength =
                              deviceList->capabilities.InputReportByteLength;
      deviceList[memberIndex].outputReportByteLength =
                              deviceList->capabilities.OutputReportByteLength;
      deviceList[memberIndex].featureReportByteLength =
                              deviceList->capabilities.FeatureReportByteLength;

      AnsiString S1 = S1.Format("InputReportByteLength=%d\
                                 OutputReportByteLength=%d\
                                FeatureReportByteLength=%d",
      OPENARRAY(TVarRec,(deviceList[memberIndex].inputReportByteLength,
                         deviceList[memberIndex].outputReportByteLength,
                     deviceList[memberIndex].featureReportByteLength)));
      Form1->Memo1->Lines->Add(S1);

      HidD_FreePreparsedData(deviceList->preparsedData);
   }
   FreeLibrary(hHidLib);
   return status;
}
//---------------------------------------------------------
UINT TUSBDevice::setGetHidDeviceData()
{
    DWORD propertyBufferSize = 0;
    char *propertyBuffer = NULL;
    HMODULE hHidLib;
    SP_DEVINFO_DATA deviceInfoData;
    HDEVINFO deviceInfoSet;
    SP_INTERFACE_DEVICE_DATA deviceInterfaceData;
    fMemberIndex = 0;
    GUID classGuid;
    PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData = NULL;
    DWORD requiredSize = 0;
    DWORD deviceInterfaceDetailDataSize = 0;
    DWORD maxDevice = searchMaxDevices; //maksymalna liczba interfejsw urzdze
    bool done = false;

    void (__stdcall *HidD_GetHidGuid)(OUT LPGUID HidGuid);

    hHidLib = LoadLibrary("HID.DLL");
    if (!hHidLib)
      displayError("Bd doczenia biblioteki HID.DLL.");

    (FARPROC&) HidD_GetHidGuid = GetProcAddress(hHidLib,
                                              "HidD_GetHidGuid");
    if (!HidD_GetHidGuid){
       FreeLibrary(hHidLib);
       displayError("Nie znaleziono identyfikatora GIUD.");
    }

    HidD_GetHidGuid (&classGuid);

    deviceInfoSet = SetupDiGetClassDevs(&classGuid, NULL, NULL,
                                       (DIGCF_PRESENT | DIGCF_DEVICEINTERFACE));

    deviceInterfaceData.cbSize = sizeof(SP_INTERFACE_DEVICE_DATA);

    while(!done) {
       for(; fMemberIndex < maxDevice; fMemberIndex++) {
          if(SetupDiEnumDeviceInterfaces(deviceInfoSet,0,&classGuid,
                                         fMemberIndex,&deviceInterfaceData)) {
            SetupDiGetDeviceInterfaceDetail(deviceInfoSet,&deviceInterfaceData,
                                         NULL,0,&deviceInterfaceDetailDataSize,
                                         NULL);
            requiredSize = deviceInterfaceDetailDataSize;
            deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)\
                                new DWORD[deviceInterfaceDetailDataSize];

               if(deviceInterfaceDetailData) {
                  deviceInterfaceDetailData->cbSize=\
                               sizeof(SP_INTERFACE_DEVICE_DETAIL_DATA);
               }
               else {
                   SetupDiDestroyDeviceInfoList(deviceInfoSet);
                   releaseMemory(deviceInterfaceDetailData);
                   return 0;
               }
               deviceInfoData.cbSize = sizeof(SP_DEVINFO_DATA);
               if (!SetupDiGetDeviceInterfaceDetail(deviceInfoSet,
                           &deviceInterfaceData, deviceInterfaceDetailData,
                           deviceInterfaceDetailDataSize,
                           &requiredSize, &deviceInfoData)) {
                   SetupDiDestroyDeviceInfoList(deviceInfoSet);
                   releaseMemory(deviceInterfaceDetailData);
                   return 0;
               }

            size_t nLen = strlen(deviceInterfaceDetailData->DevicePath) + 1;
            deviceList[fMemberIndex].Path = new TCHAR[(nLen*sizeof(TCHAR))];
            StrLCopy(deviceList[fMemberIndex].Path,
                                deviceInterfaceDetailData->DevicePath, nLen);


            Form1->ListItem = Form1->ListView1->Items->Add();
            Form1->ListItem->Caption = deviceList[fMemberIndex].Path;
            Form1->ListItem->SubItems->Add(deviceList[fMemberIndex].Path);

            deviceList[fMemberIndex].DeviceInstance = deviceInfoData.DevInst;

            SetupDiGetDeviceRegistryProperty(deviceInfoSet, &deviceInfoData,
                                        SPDRP_HARDWAREID, NULL, NULL, 0,
                                        &propertyBufferSize);

            //alokowanie pamieci dla bufora danych
            propertyBuffer = new char[(propertyBufferSize*sizeof(TCHAR))];

            SetupDiGetDeviceRegistryProperty(deviceInfoSet, &deviceInfoData,
                                           SPDRP_HARDWAREID,NULL,
                                           propertyBuffer, propertyBufferSize,
                                           NULL);

            deviceList[fMemberIndex].HardwareId  = propertyBuffer;
          }
          else {
              if(ERROR_NO_MORE_ITEMS == GetLastError()){
                done = TRUE;
                break;
              }
          }
          releaseMemory(deviceInterfaceDetailData);
          releaseMemory(propertyBuffer);
       }
    }
    SetupDiDestroyDeviceInfoList(deviceInfoSet);
    FreeLibrary(hHidLib);

    return fMemberIndex;
}
//---------------------------------------------------------
HANDLE TUSBDevice::openHidUSBDevice(UINT memberIndex)
{
   deviceList[memberIndex].hidDeviceObject == INVALID_HANDLE_VALUE;
   deviceList[memberIndex].hidDeviceObject =
                      CreateFile(deviceList[memberIndex].Path,
                                 GENERIC_READ | GENERIC_WRITE,
                                 FILE_SHARE_READ | FILE_SHARE_WRITE,
                                 NULL,OPEN_EXISTING,
                                 FILE_FLAG_OVERLAPPED,NULL);

   if(deviceList[memberIndex].hidDeviceObject != INVALID_HANDLE_VALUE)
     return deviceList[memberIndex].hidDeviceObject;
     else
       return INVALID_HANDLE_VALUE;
}
//---------------------------------------------------------
BOOL TUSBDevice::closeHidUSBDevice(HANDLE devHandle)
{
  if((devHandle == 0) ||
    (devHandle == INVALID_HANDLE_VALUE)){
    return false;
  }
  else
    return Win32Check(CloseHandle(devHandle));
}
//---------------------------------------------------------
BOOL TUSBDevice::readUSBReport(UINT memberIndex)
{
   DWORD result = 0;
   DWORD numberOfBytesRead = 0;
   OVERLAPPED *overlapped = NULL;
   if(overlapped == NULL){
       overlapped = new OVERLAPPED;
       overlapped->hEvent = CreateEvent(NULL, TRUE, TRUE, "");
       overlapped->Offset = 0;
       overlapped->OffsetHigh = 0;
   }
   if(!ReadFile(deviceList[memberIndex].hidDeviceObject,
                deviceList[memberIndex].inputReportBuffer,
                deviceList[memberIndex].inputReportByteLength,
                &numberOfBytesRead, overlapped)) {
      if(GetLastError() == ERROR_IO_PENDING) {
          result = WaitForSingleObject(overlapped->hEvent, 100);
	        if(result == WAIT_TIMEOUT) {
	            CancelIo(deviceList[memberIndex].hidDeviceObject);
	            return false;
	        }
	        else
                    if(result == WAIT_FAILED){
	              displayError("Bd odczytu danych.");
	              return false;
	            }
	        GetOverlappedResult(deviceList[memberIndex].hidDeviceObject,
                                    overlapped, &numberOfBytesRead, FALSE);
      }
      else
         displayError("Bd odczytu danych.");
   }
   ResetEvent(overlapped->hEvent);
   if(numberOfBytesRead == (UINT)deviceList[memberIndex].inputReportByteLength){
      Form1->TrackBar1->Position = deviceList[memberIndex].inputReportBuffer[1];
   }
   else {
     displayError("Bdna liczba bajtw odebranych.");
   }
   releaseMemory(overlapped);
   return true;
}
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
    ListView1->ViewStyle = vsSmallIcon;
    usbDevice = NULL;
    usbDevice = new TUSBDevice(searchMaxDevices);
    usbDevice->setGetHidDeviceData();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  if(ListView1->Selected) {//jeeli zaznaczono interfejs
      if(usbDevice->openHidUSBDevice(ListView1->Selected->Index)!= \
         INVALID_HANDLE_VALUE)
         ShowMessage("Urzdzenie odblokowane do transmisji.");
         else
           ShowMessage("Urzdzenia nie mona odblokowa do transmisji.");

      //odczyt wlasciwosci urzdzenia
      if(usbDevice->getHidDeviceCapabilities(ListView1->Selected->Index)){
         //alokowanie pamici dla bufora wejsciowego
         usbDevice->deviceList[ListView1->Selected->Index].inputReportBuffer =
         new BYTE[usbDevice->deviceList[ListView1->Selected->Index].\
                                        inputReportByteLength];

         while(true) { //cykliczny odczyt raportu wejsciowego
            usbDevice->readUSBReport(ListView1->Selected->Index);
            if(usbDevice->deviceList[ListView1->Selected->Index].\
               inputReportBuffer[6]==64) {
               //zwolnienie pamieci dla bufora wejsciowego
               releaseMemory(usbDevice->deviceList[ListView1->\
                             Selected->Index].inputReportBuffer);
               Form1->Caption = "Koniec odczytu danych.";
               break;
            }
         }
         usbDevice->closeHidUSBDevice(usbDevice->deviceList[ListView1->\
                                      Selected->Index].hidDeviceObject);
      }
   }
   else
     ShowMessage("Nie wybrano interfejsu urzdzenia.");
}
//---------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender,
                                  TCloseAction &Action)
{
   if(ListView1->Selected){
      releaseMemory(usbDevice->deviceList[ListView1->\
                                          Selected->Index].Path);
   }
   releaseMemory(usbDevice);
   Action = caFree;
}
//---------------------------------------------------------

